<?php
#	SonicCampGuard
#
#	Copyright (c) 2024 Bundeswehr
#	Diese Anwendung wurde von Cedric Prietz entwickelt.
#	E-Mail: CedricPrietz@bundeswehr.org
#	App: 90-8303-54618
#
#	Letzte Änderung: 23.09.2024

require_once $_SERVER['DOCUMENT_ROOT'] . '/function.inc.php';
pageName('Identität');
requireLogin();
requireRole(['Bediener', 'Bearbeiter', 'Administrator']);
showSessionAlert();
initializeDatabaseConnection();

$sql = "SELECT * FROM Identities WHERE ID = ? AND Type = 'Local'";
$stmt = $pdo->prepare($sql);
$stmt->execute([$_GET['id']]);

$identity = $stmt->fetch();

if (!$identity) {

    header("Location: /identities/authorized-identities");
    exit();

}

include($_SERVER['DOCUMENT_ROOT'] . '/header.inc.php');
?>

<div class="d-flex justify-content-between align-items-center flex-wrap grid-margin">
    <div>
        <h4 class="mb-md-0"><?php echo $identity['Surname'] . ", " . $identity['Givenname']; ?></h4>
        <span class="text-secondary">Identität</span>
    </div>
    <div class="d-flex align-items-center flex-wrap text-nowrap">

        <a href="/identities/authorized-identities" class="btn btn-secondary btn-icon mb-2 mb-md-0">
            <i class="mdi mdi-arrow-left-top"></i>
        </a>

    </div>
</div>

<div class="row">

    <div class="col-lg-12 col-xl-6 grid-margin stretch-card">
        <div class="card">
            <div class="card-header bg-primary text-white">
                Stammdaten
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-6">
                        <div class="mb-3">
                            <label class="form-label">Nachname</label>
                            <h4 class="title"><?php echo $identity['Surname']; ?></h4>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Vorname</label>
                            <h4 class="title"><?php echo $identity['Givenname']; ?></h4>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Geburtstag</label>
                            <h4 class="title">
                                <?php if (!empty($identity['Birthday'])) {
                                    echo $identity['Birthday'];
                                } else {
                                    echo '--';
                                }
                                ?>
                            </h4>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="mb-3">
                            <label class="form-label">Ausweis</label>
                            <h4 class="title">
                                <?php if (!empty($identity['LocalIDCard'])) {
                                    echo $identity['LocalIDCard'];
                                } else {
                                    echo '--';
                                }
                                ?>
                            </h4>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Mitarbeiterausweis</label>
                            <h4 class="title">
                                <?php if (!empty($identity['LocalEmployeeID'])) {
                                    echo $identity['LocalEmployeeID'];
                                } else {
                                    echo '--';
                                }
                                ?>
                            </h4>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-12 col-xl-3 grid-margin stretch-card">
        <div class="card">
            <div class="card-header bg-secondary text-white">
                Foto
            </div>
            <div class="card-body">
                <div class="mb-3 text-center" style="vertical-align: middle;">
                    <img class="w-175px h-200px rounded object-fit-cover" id="imagePreview" src="<?php if ($identity['Image'] == NULL) {
                        echo '../assets/images/identityPreviewPlaceholder.png';
                    } else {
                        echo '../uploads/identities/' . $identity['Image'];
                    } ?>" alt="Passfoto">
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-12 col-xl-3 grid-margin stretch-card">
        <div class="card">
            <div class="card-header bg-warning text-white">
                <div class="d-flex justify-content-between align-items-baseline">
                    Zutrittsberechtigung
                </div>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <label class="form-label">Zutritt ab</label>
                    <h4 class="title"><?php echo $identity['IdentityIN']; ?></h4>
                </div>
                <div class="mb-3">
                    <label class="form-label">Zutritt bis</label>
                    <h4 class="title"><?php echo $identity['IdentityOUT']; ?></h4>
                </div>
                <div class="mb-3">
                    <label class="form-label">Karte</label>
                    <h4 class="title text-danger"><?php echo $identity['AccessCard']; ?></h4>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-12 col-xl-8 grid-margin">
        <div class="card">
            <div class="card-header bg-secondary text-white">
                Notizen
            </div>
            <div class="card-body">
                <textarea class="form-control" name="identityNotes" id="authorizedIdentityNotesMDE"
                    rows="10"><?php echo $identity['Notes']; ?></textarea>
            </div>
        </div>
    </div>

</div>

<?php include($_SERVER['DOCUMENT_ROOT'] . '/footer.inc.php'); ?>